definition module StdBitmap


//	********************************************************************************
//	Clean Standard Object I/O library, version 1.0.1
//	
//	StdBitmap contains functions for reading bitmap files and drawing bitmaps.
//	********************************************************************************


import	StdMaybe
from	StdFile	import FileSystem
import	StdPicture


getBitmapSize	:: !Bitmap -> Size
/*	getBitmapSize returns the size of the given bitmap.
	In case the bitmap is the result of an erroneous openBitmap, then the size is 
	zero.
*/

::	Bitmap

openBitmap		:: !{#Char} !*env -> (!Maybe Bitmap,!*env)	| FileSystem env
/*	openBitmap reads in a bitmap from file.
	The String argument must be the file name of the bitmap.
	If the bitmap could be read, then (Just bitmap) is returned, otherwise Nothing 
	is returned.
*/

instance Drawables Bitmap
/*	draw       bitmap
		draws the given bitmap with its left top at the current pen position.
	drawAt pos bitmap
		draws the given bitmap with its left top at the given pen position.
*/
